/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import DE.siemens.ad.logo.util.ConnectionPanel;
import DE.siemens.ad.logo.util.Language;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ConnectionMarkerPanel
extends ConnectionPanel {
    private int fLineNr;
    protected int fOffset;
    private static int[] fConnectorX = new int[]{6, 10, 14, 18, 22, 26, 30, 34, 9, 17, 25, 33};

    public ConnectionMarkerPanel(int lineNr) {
        this.fLineNr = lineNr;
        this.fOffset = lineNr < fConnectorX.length ? fConnectorX[lineNr] : 0;
    }

    public Color getDefaultColor() {
        Color[] colors = new Color[]{Color.GREEN, Color.ORANGE, Color.PINK, Color.MAGENTA, Color.RED, Color.BLUE, new Color(153, 153, 0), Color.YELLOW, Color.WHITE, new Color(2330216), new Color(153, 51, 255), Color.CYAN};
        return colors[this.fLineNr];
    }

    public String getKey() {
        String key = "marker.line.color." + this.fLineNr;
        return key;
    }

    public String getPreviewName() {
        return Language.getString("dialog.options.color.marker.line", "Marker Line %", this.fLineNr + 1);
    }

    public void setConnectionColor(Color color) {
        super.setConnectionColor(color);
    }

    protected JLabel getInputLabel() {
        if (this.fInputLabel == null) {
            this.fInputLabel = new JLabel("           ");
        }
        return this.fInputLabel;
    }

    protected JLabel getOutputLabel() {
        if (this.fOutputLabel == null) {
            this.fOutputLabel = new JLabel("           ");
        }
        return this.fOutputLabel;
    }

    protected JLabel getConnectionLabel() {
        return new JLabel(this.getFBImageIcon("EmptyBlockIcon.gif", this.fFBBgColor));
    }

    protected JPanel getPreviewPanel() {
        if (this.fPreviewPanel == null) {
            this.fPreviewPanel = new JPanel(){

                public void paint(Graphics g) {
                    int i;
                    super.paint(g);
                    Dimension size = this.getSize();
                    int xCenter = size.width / 2;
                    int figureLeftX = xCenter - 12;
                    int figureRightX = xCenter + 12;
                    if (ConnectionMarkerPanel.this.fOffset == 9 || ConnectionMarkerPanel.this.fOffset == 17 || ConnectionMarkerPanel.this.fOffset == 25 || ConnectionMarkerPanel.this.fOffset == 33) {
                        g.drawLine(figureRightX, ConnectionMarkerPanel.this.fOffset, figureRightX + 50, ConnectionMarkerPanel.this.fOffset);
                    } else {
                        g.drawLine(xCenter - 58, ConnectionMarkerPanel.this.fOffset, figureLeftX, ConnectionMarkerPanel.this.fOffset);
                    }
                    g.setColor(Color.BLACK);
                    g.drawRect(figureLeftX, 5, 24, 32);
                    int offset = fConnectorX[0];
                    for (i = 0; i < 8; ++i) {
                        g.drawLine(figureLeftX - 5, offset, figureLeftX, offset);
                        offset += 4;
                    }
                    offset = fConnectorX[8];
                    for (i = 0; i < 4; ++i) {
                        g.drawLine(figureRightX, offset, figureRightX + 5, offset);
                        offset += 8;
                    }
                }
            };
            this.fPreviewPanel.setLayout(new FlowLayout());
            this.fPreviewPanel.setBackground(this.fBackgroundColor);
            this.fPreviewPanel.add(this.getInputLabel());
            this.fPreviewPanel.add(this.getConnectionLabel());
            this.fPreviewPanel.add(this.getOutputLabel());
            this.setConnectionColor(this.getColor());
        }
        return this.fPreviewPanel;
    }
}

